//*************+***************+***************+***************+***************+
//
//	
//
//	FileName	: 
//	CPU			: x86
//	Compiler	: Microsoft Visual C++ 2005       77971-009-0000007-41760
//
//*************+***************+***************+***************+***************+
//	2007.09.14	Horino	VK쐬
//*************+***************+***************+***************+***************+
// EditLogBox.cpp : Cve[V t@C
//

#include "stdafx.h"
#include <winnls.h>
#include <mmsystem.h>
#include "EditLogBox.h"

#pragma comment(lib, "winmm.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#define ONELINE_LENGTH_MAX		1024							// Ps̍ő啶

//#define OPT_OSVERSIONINFOEX

typedef void (WINAPI *PGNSI)(LPSYSTEM_INFO); 



/////////////////////////////////////////////////////////////////////////////
// CEditLogBox

//*************+***************+***************+***************+***************+
CEditLogBox::CEditLogBox()
{
	// oϐ ---------------
	m_iListNumber	= 1024;

	InitializeCriticalSection(&m_csWriteLog);					// NeBJZNV
}

CEditLogBox::~CEditLogBox()
{
	DeleteCriticalSection(&m_csWriteLog);						// NeBJZNVj
}


BEGIN_MESSAGE_MAP(CEditLogBox, CListBox)
	//{{AFX_MSG_MAP(CEditLogBox)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
	ON_WM_CREATE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditLogBox bZ[W nh


int CEditLogBox::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CEdit::OnCreate(lpCreateStruct) == -1)
		return -1;

	// TODO:  ɓȍ쐬R[hǉĂB

	return 0;
}

BOOL CEditLogBox::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	return CEdit::PreCreateWindow(cs);
}

BOOL CEditLogBox::Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	return CEdit::Create(dwStyle, rect, pParentWnd, nID);
}

BOOL CEditLogBox::CreateEx(DWORD dwExStyle, LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, LPVOID lpParam)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	return CEdit::CreateEx(dwExStyle, lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, lpParam);
}

//*************+***************+***************+***************+***************+
void CEditLogBox::PreSubclassWindow() 
{
	// X^C̕ύX
	CEdit::ModifyStyle(0   ,ES_AUTOHSCROLL | ES_MULTILINE | ES_READONLY | WS_VSCROLL | WS_HSCROLL  );
	CEdit::SetReadOnly();

	//// x[X
	CEdit::PreSubclassWindow();
	CEdit::SetLimitText(1024 * m_iListNumber);
	
	// tHg̕ύX
	m_NewFont.CreatePointFont(90, _T("lr SVbN"));
	SetFont(&m_NewFont);

	//LogStartLog();												// Oǉ
	//LogOsVersionInfo();
	//LogCpuName();
	//LogChipset();
	//LogRamSize();
	//LogComputerName();
}


//*************+***************+***************+***************+***************+
void CEditLogBox::ClearLog()
{
//	EnterCriticalSection(&m_csWriteLog);

	CEdit::SetWindowTextA("");

//	LeaveCriticalSection(&m_csWriteLog);
}


//*************+***************+***************+***************+***************+
void	CEditLogBox::AddInfo(void)
{
	LogStartLog();												// Oǉ
	LogOsVersionInfo();
	LogCpuName();
	LogChipset();
	LogRamSize();
	LogComputerName();
}


//*************+***************+***************+***************+***************+
void CEditLogBox::AddLog(const char *pstrLog)
{
//	EnterCriticalSection(&m_csWriteLog);

	CEdit::SetSel(0x7fffffff, 0x7fffffff, TRUE);
	CEdit::ReplaceSel( pstrLog );								// Oǉ
	CEdit::SetSel(0x7fffffff, 0x7fffffff, TRUE);
	CEdit::ReplaceSel( _T("\r\n") );							// Oǉ
	CEdit::SetSel(0x7fffffff, 0x7fffffff, FALSE);

	LimitListNumber();											// s

//	LeaveCriticalSection(&m_csWriteLog);
}

//*************+***************+***************+***************+***************+
void	CEditLogBox::ClearSplit()
{
	GetSplitTime();
}

//*************+***************+***************+***************+***************+
void CEditLogBox::AddSplit(TCHAR *pFormat, ... )
{
	TCHAR		szLogString[ONELINE_LENGTH_MAX];
	int			iHeaderLen;
	va_list		ap ;
	DWORD		dwSplitTime;
	
	dwSplitTime	= GetSplitTime();
	if(1000000 > dwSplitTime )
		iHeaderLen	= sprintf_s( szLogString, sizeof(szLogString), _T("[+%6ldms]")		, dwSplitTime );
	else
		iHeaderLen	= sprintf_s( szLogString, sizeof(szLogString), _T("[+Over  ms]")	, dwSplitTime );

	va_start( ap, pFormat );
	vsprintf_s( &szLogString[iHeaderLen], sizeof(szLogString) - iHeaderLen, pFormat, ap);
	va_end(ap) ;
	
	AddLog( szLogString );										// Oǉ
}

//*************+***************+***************+***************+***************+
void CEditLogBox::AddComment(TCHAR *pFormat, ... )
{
	TCHAR		szLogString[ONELINE_LENGTH_MAX];
	int			iHeaderLen;
	va_list		ap ;
	
	iHeaderLen	= sprintf_s( szLogString, sizeof(szLogString), _T("[         ]:"));

	va_start( ap, pFormat );
	_vstprintf_s( &szLogString[iHeaderLen], sizeof(szLogString) - iHeaderLen, pFormat, ap);
	va_end(ap) ;
	
	AddLog( szLogString );										// Oǉ
}

//*************+***************+***************+***************+***************+
void CEditLogBox::SetLogNumber(int iNumber)
{
	if(10 > iNumber)	iNumber	= 10;
	m_iListNumber	= iNumber;
	LimitListNumber();													// s
	CEdit::SetLimitText(1024 * m_iListNumber);
}

//*************+***************+***************+***************+***************+
// s
void CEditLogBox::LimitListNumber()
{
	while( CEdit::GetLineCount() > m_iListNumber)
	{
		CEdit::SetSel(0, CEdit::LineLength(0)+1, TRUE);
		CEdit::ReplaceSel((LPCTSTR)_T(""));
	}
	CEdit::SetSel(0x7fffffff, 0x7fffffff, FALSE);

	//int nStartChar, nEndChar;
	//CEdit::GetSel(nStartChar, nEndChar);
	//CEdit::SetSel(nEndChar, nEndChar, FALSE);
}

//*************+***************+***************+***************+***************+
//	O񂩂̌oߎԂ擾
DWORD CEditLogBox::GetSplitTime()
{
	DWORD			dwResTime;
	
//	dwResTime	= GetTickCount() - dwOldTime;
	dwResTime	= timeGetTime() - m_dwOldTime;
	
	m_dwOldTime	+= dwResTime;
	return( dwResTime );
}


//*************+***************+***************+***************+***************+
// Nbv{[h
bool CEditLogBox::CopyClipboard()
{
	CString	strText;

	CEdit::GetWindowText(strText);

	// 񂪋̏ꍇ̓Rs[Ȃ
	if( strText.IsEmpty() )
		return FALSE;

	// Nbv{[h̃I[v
	if( !::OpenClipboard(NULL) )
		return FALSE;

	// q[vɃ̈mۂARs[
	int iStrLen = strText.GetLength() + 1;
	HGLOBAL hMem = ::GlobalAlloc(GMEM_FIXED, iStrLen);
	LPTSTR pMem = (LPTSTR)hMem;
	::lstrcpy(pMem, (LPCTSTR)strText);

	// Nbv{[h֕Rs[AN[Y
	::EmptyClipboard();	// Nbv{[h̒gɂ
	::SetClipboardData(CF_TEXT, hMem);
	::CloseClipboard();

	return TRUE;
}


//*************+***************+***************+***************+***************+

//-----+-------+-------+-------+-------+-------+-------+-------+
// Jn
bool CEditLogBox::LogStartLog()
{
	char		szLogString[ONELINE_LENGTH_MAX];
	SYSTEMTIME	today;

	GetSplitTime();
	GetLocalTime( &today );
	sprintf_s( szLogString, sizeof(szLogString),
			_T("[#%04d/%02d/%02d %02d:%02d:%02d.%03d]") ,
			 today.wYear, today.wMonth, today.wDay, today.wHour, today.wMinute, today.wSecond, today.wMilliseconds );
	AddLog(szLogString);
	return( true );
}

//-----+-------+-------+-------+-------+-------+-------+-------+
// Rs[^
bool CEditLogBox::LogComputerName()
{
	char	szComputerName[UCHAR_MAX + 1];
	DWORD	dwComputerNameLen	= UCHAR_MAX; //MAX_COMPUTERNAME_LENGTH;
	bool	blRes;
	
	// Rs[^
	if( ( blRes = (GetComputerNameA( szComputerName, &dwComputerNameLen )!=0) ) )
	{
		AddComment( "ComputerName  :%s\n", szComputerName );
	}
	else
	{
		DWORD	dwLastError;
		dwLastError	= GetLastError();
		AddComment( "ComputerName  :Error(%d)\n", dwLastError );
	}
	return( blRes );
}

//-----+-------+-------+-------+-------+-------+-------+-------+
// Cpu
bool CEditLogBox::LogCpuName()
{
	HKEY hKey;
	char szCpuName[ONELINE_LENGTH_MAX];
	DWORD dwBufLen=ONELINE_LENGTH_MAX;
	LONG lRet;
	CString	strCpu;

	lRet = RegOpenKeyExA( HKEY_LOCAL_MACHINE, "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0",
						0, KEY_QUERY_VALUE, &hKey );
	if( lRet != ERROR_SUCCESS )
		return false;

	lRet = RegQueryValueExA( hKey, "ProcessorNameString", NULL, NULL, (LPBYTE) szCpuName, &dwBufLen);
	if( (lRet != ERROR_SUCCESS) || (dwBufLen > ONELINE_LENGTH_MAX) )
		return false;

	RegCloseKey( hKey );

//	strCpu.TrimLeft(szCpuName);
	//strCpu	= szCpuName;
	//strCpu.TrimLeft();
	//AddComment( "CPU           :%s", strCpu );
	AddComment( "CPU           :%s", szCpuName );

	return( true );
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// RAMTCY
bool CEditLogBox::LogRamSize()
{
#if 0
	MEMORYSTATUS	MemInfo;

	MemInfo.dwLength	= sizeof(MEMORYSTATUS);
	GlobalMemoryStatus(&MemInfo);
	AddComment( "RAM           :%d[MB] (%d[bytes])", MemInfo.dwTotalPhys/1024/1024, MemInfo.dwTotalPhys );
#else
	MEMORYSTATUSEX	MemInfo;

	MemInfo.dwLength	= sizeof(MEMORYSTATUSEX);
	GlobalMemoryStatusEx((LPMEMORYSTATUSEX)&MemInfo);
	if(MemInfo.ullTotalPhys < 1024*1024*1024)
		AddComment( "RAM           :%d[MB] (%d[bytes])", MemInfo.ullTotalPhys/1024/1024, MemInfo.ullTotalPhys );
	else
		AddComment( "RAM           :%d[MB] ", MemInfo.ullTotalPhys/1024/1024);
#endif
	return( true );
}




//-----+-------+-------+-------+-------+-------+-------+-------+
// Chipset
bool CEditLogBox::LogChipset()
{
	return( true );
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// OS
//	QlFhttp://pmakino.jp/tdiary/20090627.html
bool CEditLogBox::LogOsVersionInfo()
{
	#define BUFSIZE 80

	char			szLogString[ONELINE_LENGTH_MAX];
	OSVERSIONINFOEX	osvi;
	SYSTEM_INFO		si;
	BOOL			bOsVersionInfoEx;
	
	// o[W擾
	ZeroMemory( &osvi, sizeof(OSVERSIONINFOEX) );
	osvi.dwOSVersionInfoSize	= sizeof(OSVERSIONINFOEX);
	
	if( !(bOsVersionInfoEx = GetVersionEx ((OSVERSIONINFO *) &osvi)) ){
		osvi.dwOSVersionInfoSize	= sizeof(OSVERSIONINFO);
		if (! GetVersionEx ( (OSVERSIONINFO *) &osvi) ) 
			return false;
	}

	// 
	ZeroMemory(&si, sizeof(SYSTEM_INFO));

	PGNSI	pGNSI	= (PGNSI)GetProcAddress(GetModuleHandle(TEXT("kernel32.dll")), "GetNativeSystemInfo");
	if(pGNSI)
		pGNSI(&si);
	else
		GetSystemInfo(&si);

	
	strcpy_s( szLogString, sizeof(szLogString), "OS            :");
	
	switch (osvi.dwPlatformId){
	case VER_PLATFORM_WIN32_NT:							// Test for the Windows NT product family.
		if ( osvi.dwMajorVersion == 6 && osvi.dwMinorVersion == 1 )
			strcat_s( szLogString, sizeof(szLogString), "Microsoft Windows 7");
		if ( osvi.dwMajorVersion == 6 && osvi.dwMinorVersion == 0 )
			strcat_s( szLogString, sizeof(szLogString), "Microsoft Windows Vista");
		if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 2 )
			strcat_s( szLogString, sizeof(szLogString), "Microsoft Windows .NET Server 2003 family");
		if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 1 )
			strcat_s( szLogString, sizeof(szLogString), "Microsoft Windows XP");
		if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 0 )
			strcat_s( szLogString, sizeof(szLogString), "Microsoft Windows 2000");
		if ( osvi.dwMajorVersion <= 4 )
			strcat_s( szLogString, sizeof(szLogString), "Microsoft Windows NT");

#ifdef OPT_OSVERSIONINFOEX		// wProductTypewSuiteMask
		if( bOsVersionInfoEx ){								// Test for specific product on Windows NT 4.0 SP6 and later.
			if ( osvi.wProductType == VER_NT_WORKSTATION ){		// Test for the workstation type.
				if( osvi.dwMajorVersion == 4 )
					strcat( szLogString, "Workstation 4.0 " );
				else if( osvi.wSuiteMask & VER_SUITE_PERSONAL )
					strcat( szLogString, "Home Edition " );
				else
					strcat( szLogString, "Professional " );
			}
			else if ( osvi.wProductType == VER_NT_SERVER ){		// Test for the server type.
				if( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 2 ){
					if( osvi.wSuiteMask & VER_SUITE_DATACENTER )
						strcat( szLogString, "Datacenter Edition " );
					else if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
						strcat( szLogString, "Enterprise Edition " );
					else if ( osvi.wSuiteMask == VER_SUITE_BLADE )
						strcat( szLogString, "Web Edition " );
					else
						strcat( szLogString, "Standard Edition " );
				}
				else if( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 0 ){
					if( osvi.wSuiteMask & VER_SUITE_DATACENTER )
						strcat( szLogString, "Datacenter Server " );
					else if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
						strcat( szLogString, "Advanced Server " );
					else
						strcat( szLogString, "Server " );
				}
				else{												// Windows NT 4.0 
					if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
						strcat( szLogString,"Server 4.0, Enterprise Edition " );
					else
						strcat( szLogString, "Server 4.0 " );
				}
			}
		}
#else
		if(0);
#endif
		else{												// Test for specific product on Windows NT 4.0 SP5 and earlier
			if((osvi.dwMajorVersion == 6 && osvi.dwMinorVersion == 0)
			|| (osvi.dwMajorVersion == 6 && osvi.dwMinorVersion == 1))
			{
				HMODULE	hModule;
				BOOL (CALLBACK* pfnGetProductInfo)(DWORD dwOSMajorVersion,DWORD dwOSMinorVersion,DWORD dwSpMajorVersion,DWORD dwSpMinorVersion,PDWORD pdwReturnedProductType);
				DWORD dwReturnedProductType = 0x00000000;

				hModule = ::LoadLibrary(_T("kernel32.dll"));
				(*(FARPROC*)&pfnGetProductInfo) = ::GetProcAddress(hModule, "GetProductInfo");
				if(hModule != NULL && pfnGetProductInfo != NULL)
				{
					if (pfnGetProductInfo(
						osvi.dwMajorVersion,
						osvi.dwMinorVersion,
						osvi.wServicePackMajor,
						osvi.wServicePackMinor,
						&dwReturnedProductType))
					{
						switch (dwReturnedProductType)
						{
						case 0x00000004:
						case 0x0000001B:
							strcat_s( szLogString, sizeof(szLogString), " Enterprise Edition");
							break;
						case 0x00000001:
						case 0x0000001C:
							strcat_s( szLogString, sizeof(szLogString), " Ultimate Edition");
							break;
						case 0x00000006:
							strcat_s( szLogString, sizeof(szLogString), " Business Edition");
							break;
						case 0x00000003:
						case 0x0000001A:
							strcat_s( szLogString, sizeof(szLogString), " Home Premium Edition");
							break;
						case 0x00000002:
							strcat_s( szLogString, sizeof(szLogString), " Home Basic Edition");
							break;
						case 0x00000030:
						case 0x00000031:
							strcat_s( szLogString, sizeof(szLogString), " Professional Edition");
							break;
						default:
							strcat_s( szLogString, sizeof(szLogString), " Unknown Edition");
							break;
						}
					}
				}
			}
			else
			{
				HKEY hKey;
				char szProductType[BUFSIZE];
				DWORD dwBufLen=BUFSIZE;
				LONG lRet;

				lRet = RegOpenKeyExA( HKEY_LOCAL_MACHINE, "SYSTEM\\CurrentControlSet\\Control\\ProductOptions",
									0, KEY_QUERY_VALUE, &hKey );
				if( lRet != ERROR_SUCCESS )
					return FALSE;

				lRet = RegQueryValueExA( hKey, "ProductType", NULL, NULL, (LPBYTE) szProductType, &dwBufLen);
				if( (lRet != ERROR_SUCCESS) || (dwBufLen > BUFSIZE) )
					return FALSE;

				RegCloseKey( hKey );

				if ( lstrcmpiA( "WINNT", szProductType) == 0 )
				{
					if ( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 1 )
						strcat_s( szLogString, sizeof(szLogString), " Professional" );
					else
						strcat_s( szLogString, sizeof(szLogString), " Workstation" );
				}
				if ( lstrcmpiA( "LANMANNT", szProductType) == 0 )
					strcat_s( szLogString, sizeof(szLogString), " Server" );
				if ( lstrcmpiA( "SERVERNT", szProductType) == 0 )
					strcat_s( szLogString, sizeof(szLogString), " Advanced Server" );

				sprintf_s( szProductType, sizeof(szProductType), " %d.%d", osvi.dwMajorVersion, osvi.dwMinorVersion );
				strcat_s( szLogString, sizeof(szLogString), szProductType );
			}
		}

		// Display service pack (if any) and build number.
		char szServicePack[BUFSIZE];
		if( osvi.dwMajorVersion == 4 && 
				lstrcmpiA( (LPCSTR)osvi.szCSDVersion, "SP 6" ) == 0 )
		{
			HKEY hKey;
			LONG lRet;

			// Test for SP6 versus SP6a.
			lRet = RegOpenKeyExA( HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Hotfix\\Q246009",
								0, KEY_QUERY_VALUE, &hKey );
			if( lRet == ERROR_SUCCESS ){
				sprintf_s( szServicePack, sizeof(szServicePack), " SP 6a (Build %d)", osvi.dwBuildNumber & 0xFFFF );
			}
			else{								// Windows NT 4.0 prior to SP6a
				sprintf_s( szServicePack, sizeof(szServicePack), " %s (Build %d)", osvi.szCSDVersion, osvi.dwBuildNumber & 0xFFFF);
			}
			RegCloseKey( hKey );
		}
		else{												// Windows NT 3.51 and earlier or Windows 2000 and later
			sprintf_s( szServicePack, sizeof(szServicePack), " %s (Build %d)", osvi.szCSDVersion, osvi.dwBuildNumber & 0xFFFF);
		}
		strcat_s( szLogString, sizeof(szLogString), szServicePack );
		break;
		
	case VER_PLATFORM_WIN32_WINDOWS:				// Test for the Windows 95 product family.
		if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 0){
				strcat_s( szLogString, sizeof(szLogString), "Microsoft Windows 95");
				if ( osvi.szCSDVersion[1] == 'C' || osvi.szCSDVersion[1] == 'B' )
					strcat_s( szLogString, sizeof(szLogString)," OSR2" );
		} 
		
		if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 10){
			strcat_s( szLogString, sizeof(szLogString), "Microsoft Windows 98");
			if ( osvi.szCSDVersion[1] == 'A' )
				strcat_s( szLogString, sizeof(szLogString), " SE" );
		} 
		
		if (osvi.dwMajorVersion == 4 && osvi.dwMinorVersion == 90){
				strcat_s( szLogString, sizeof(szLogString), "Microsoft Windows Millennium Edition");
		} 
		break;
		
	case VER_PLATFORM_WIN32s:
		strcat_s( szLogString, sizeof(szLogString), "Microsoft Win32s");
		break;
	}

	if(1)
	{
		if (si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_AMD64)  
			strcat_s( szLogString, sizeof(szLogString), TEXT(", 64-bit"));  
		else if (si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_INTEL)  
			strcat_s( szLogString, sizeof(szLogString), TEXT(", 32-bit"));  
	}

	AddComment(szLogString);

#if 0
	AddComment( "MajorVersion  :%8d[0x%08x]\n", osvi.dwMajorVersion, osvi.dwMajorVersion );
	AddComment( "MinorVersion  :%8d[0x%08x]\n", osvi.dwMinorVersion, osvi.dwMinorVersion );
	AddComment( "BuildNumber   :%8d[0x%08x]\n", osvi.dwBuildNumber, osvi.dwBuildNumber );
	AddComment( "PlatformId    :%8d[0x%08x]\n", osvi.dwPlatformId, osvi.dwPlatformId );
	AddComment( "CSDVersion    :%s\n", osvi.szCSDVersion  );
#ifdef OPT_OSVERSIONINFOEX		// wProductTypewSuiteMask
	if( bOsVersionInfoEx ){
		AddComment( "SPMajor       :%8d[0x%08x]\n", osvi.wServicePackMajor, osvi.wServicePackMajor );
		AddComment( "SPMinor       :%8d[0x%08x]\n", osvi.wServicePackMinor, osvi.wServicePackMinor );
		AddComment( "Reserved[0]   :%8d[0x%08x]\n", osvi.wReserved[0], osvi.wReserved[0] );
		AddComment( "Reserved[1]   :%8d[0x%08x]\n", osvi.wReserved[1], osvi.wReserved[1] );
	}
#endif
#endif
	return( true );
}


//-----+-------+-------+-------+-------+-------+-------+-------+
// t@C֏
bool CEditLogBox::SaveLog(char *pstrFilename)
{
	//CString	strText;

	//CEdit::GetWindowText(strText);

	//// 񂪋̏ꍇ̓Rs[Ȃ
	//if( strText.IsEmpty() )
	//	return FALSE;

	//FILE		*stream;
	//
	//stream	= fopen( pstrFilename,  "w" );
	//if( stream != NULL )
	//{
	//	fputs( (const char *)strText. , stream );
	//	fclose( stream );
	//}

	return TRUE;
}


